
![[Pasted image 20250518165214.png]]

## **Overview**

- **Umbrella Web Security**: Provides deep control and visibility for HTTP and HTTPS traffic.
- **Umbrella Cloud-Delivered Firewall (CDFW)**: Inspects all ports and protocols for comprehensive security.
- **Traffic Forwarding**: Requires configuring an **IPsec tunnel** from a network device to route traffic to Umbrella for multiple layers of internet threat defense.

---

## **Key Functions of Umbrella CDFW**

### **1. Layers of Defense**

- **Web Traffic**: Routed via IPsec tunnel to:
    - **Secure Web Gateway (SWG)** for web inspection over TCP ports 80 and 443.
    - **DNS-layer security** for DNS requests.
    - **CDFW** for all other traffic.
- **Traffic Rules**:
    - **Layer 3 & 4**: Controls ports and protocols.
    - **Layer 7**: Provides application visibility and control.
- **Intrusion Prevention System (IPS)**: Adds signature-based threat detection against malware, botnets, phishing, and more.

### **2. Intrusion Prevention System (IPS)**

- Signature-based detection using thousands of unique malware and threat signatures.
- Works with CDFW to detect or block threats.
- IPS is enabled for the entire environment, including all network tunnels.

---

## **Connection Method to CDFW**

### **IPsec Tunnel Configuration**

- **Steps to Set Up:**
    1. **Create an IPsec IKEv2 Tunnel**: From any supported network device to Umbrella.
    2. **Set Up the Network Tunnel**: Configure the tunnel in Umbrella.
    3. **Integrate with Firewall Policy**: Add the tunnel identity to a firewall policy.
- **Technical Specifications**:
    - Maximum Transmission Unit (MTU): ≤ 1400 bytes.
    - Maximum Segment Size (MSS): ≤ 1360 bytes.
    - **Fragmented packets** in underlay/overlay are dropped.
- **Automated Deployment**:
    - Cisco Catalyst SD-WAN (formerly Viptela) automates tunnel creation and IPsec configuration.

---

## **Firewall Policy**

### **Purpose**

- Manages CDFW and IPS configurations.
- Creates rules to filter traffic based on actions, ports, protocols, and applications.

### **Steps to Create a Firewall Rule**

1. **Basic Rule Characteristics**:
    - **Name & Description**: Provide a descriptive identifier.
    - **Priority Order**: Determines the sequence of rule evaluation (Default Rule applied last).
    - **Rule Action**: Choose **Allow** or **Block**.
2. **Criteria for Rule**:
    - **Protocol**: TCP, UDP, ICMP, or any.
    - **Source Tunnels**: Specify source identity.
    - **Source/Destination IPs**: Use IP or CIDR ranges (e.g., Any or Specify).
    - **Source/Destination Ports**: Define port(s) or port ranges.
    - **Applications**: Specify apps or categories affected by the rule.
3. **Additional Settings**:
    - Time Zone and Rule Expiry (optional: "Does Not Expire").
    - Enable/Disable Logging: Disabled by default.
    - Hit Counter Interval: Tracks rule hits; disabled if logging is off.

---

## **IPS Configuration**

### **Default IPS Settings**

- Enabled in the firewall policy to detect or block threats.
- **Modes**:
    - **Detection Mode**: Logs potential threats without blocking traffic.
    - **Protection Mode**: Blocks destinations matching malicious signatures.
- **Signature Lists**:
    - Predefined lists balance **network connectivity** and **security**:
        1. **Connectivity Over Security**: Focus on throughput; minimal rules enforced.
        2. **Balanced Security and Connectivity**: A balance of security and performance.
        3. **Security Over Connectivity**: Prioritizes security; may cause more false positives.
        4. **Maximum Detection**: Highest security; impacts network connectivity and throughput.

### **Custom IPS Signature Lists**

- Allows tailored configuration of signature actions (Block, Log Only, Ignore).
- Based on default signature lists to meet specific network needs.

---

## **Key Notes and Best Practices**

- **IPsec Tunnel Requirements**:
    - MTU ≤ 1400 bytes and MSS ≤ 1360 bytes.
    - Ensure no fragmented packets in underlay or overlay.
- **Firewall Policy Rule Evaluation**:
    - Rules are evaluated sequentially based on priority.
    - If a rule matches, subsequent rules are not applied.
- **IPS Monitoring**:
    - Use **Detection Mode** to test IPS settings without impacting traffic.
    - Regularly review signature lists to balance security and connectivity.